import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { SavingsService } from '../_services/savings.service';
import { Title } from '@angular/platform-browser';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { GroupService } from '../_services/group.service';
import { LoanService } from '../_services/loan.service';
import { MemberService } from '../_services/member.service';
import { Member } from '../_models/member';
import { Group } from '../_models/group';
import { Saving } from '../_models/saving';
import { Loan } from '../_models/loan';

@Component({
    selector: 'app-savingscreate',
    templateUrl: './savingscreate.component.html',
    styleUrls: ['./savingscreate.component.css'],
    providers: [SavingsService]
})
export class SavingscreateComponent implements OnInit {
    pageTitle = "CAPEP KENYA : Savings Deposit"

    savingsForm: FormGroup;

    member: Member;
    members: Member[]
    group: Group;
    groups: Group[]
    loan: Loan;
    loans: Loan[];
    saving: Saving;
    savings: Saving[]
    _savings_bf: number;
    _savings_total: number;
    _total_savings: number;
    _group_id: string;
    _group_name: string;
    _group_code: string;
    _group_officer: string;
    _member_name: string;
    _member_id: string;
    _member_id_fk: string;
    _membership_no: number;
    _member_id_no: string;
    _loan_repay: any;
    loanrepays: any;
    _total_repay: number;
    _loan_bf: number;
    lrates: any;
    _loan_interest: number;
    _adv_bf: number;
    _adv_loan_interest: number;
    successMsg: string;
    errorMsg: any;
    public savingsBF: boolean = false
    _pendingMsg: string;
    _pendingAdvMsg: string;
    _pendingLoansMsg: string;



    constructor(private title: Title, private groupService: GroupService, private loanService: LoanService, private formBuilder: FormBuilder, private memberService: MemberService, private savingsService: SavingsService, private route: ActivatedRoute) { }

    ngOnInit() {
        this.title.setTitle(this.pageTitle)

        this.savingsForm = this.formBuilder.group({
            group_id: [null],
            group_name: [null],
            group_code: [null],
            group_officer: [null],
            member_id: [null],
            member_name: [null],
            membership_no: [null],
            member_id_no: [null],
            savings_bf: [0],
            savings_bf2: [0],
            loans_bf: [null],
            adv_bf: [null],
            total_payments: [null],
            savings_amount: [null],
            principal_amount: [null],
            principal_adv: [null],
            loan_interest: [null],
            adv_loan_interest: [null],
            fines: [null],
            asante: [null],
            default: [null],
            savings_date: [null],
            loan_id_fk: [null],
            adv_id_fk: [null],
            comments: [null]
        });


        // fetch member by ID
        this.route.paramMap.subscribe((params: ParamMap) => {
            let id = parseInt(params.get('id'));
            //get member details
            this.memberService.getMemberById(id)
                .subscribe(data => {
                    this.member = data;
                    this._group_id = this.member.map(function (a) { return a['group_id']; });
                    this._group_name = this.member.map(function (a) { return a['group_name']; });
                    this._group_code = this.member.map(function (a) { return a['group_code']; });
                    this._member_id = this.member.map(a => a.member_id);
                    //this._group_officer = this.member.map(function (a) { return a['group_officer']; });
                    this._member_name = this.member.map(function (a) { return a['member_name']; });
                    this._membership_no = +this.member.map(function (a) { return a['membership_no']; });
                    this._member_id_no = this.member.map(function (a) { return a['member_id_no']; });

                    this.savingsForm.patchValue({
                        member_id: this._member_id
                    })
                });


             

            //begin savings bf input display
            
            this.savingsService.getSavings()
                .subscribe(data => {
                    this.savings = data;
                    console.log("this savings", this.savings)
                    if (this.savings.some(saving => saving.member_id_fk === +this.savingsForm.value.member_id && this.savingsForm.value.savings_bf2 > 0)) {
                        console.log("This loan id is present")
                        this.savingsBF = false
                    } else { 
                        this.savingsBF = true
                        console.log("This loan id is not present")
                        this.savingsForm.patchValue({
                            savings_bf: ""
                        })
                    }
                })

            //BEGIN SAVINGS FETCH          
            this.savingsService.getSavingsById(id).subscribe(s => {
                this.savings = s;
                console.log("This member savings", this.savings);
                //if 
                //get total savings
                this._savings_total = +this.savings.reduce((result, a) => {
                    var savings_amount = a.savings_amount;
                    return result + savings_amount;
                }, 0);
                //get savings bf
                this._savings_bf = +this.savings.reduce((result, a) => {
                    let savings_bf = a.savings_bf;
                    return result + savings_bf;
                }, 0);

                //get default bf
                let _default_bf = +this.savings.reduce((result, a) =>{
                  let default_value = a.default_amount;
                  return result + default_value;
                },0)
                //Get total savings bf
                this._total_savings = this._savings_total + this._savings_bf - _default_bf;
               
                this.savingsForm.patchValue({
                    savings_bf2: this._total_savings
                })

            });
            //END SAVINGS FETCH

            //check if member exists in loan table
            this.loanService.getLoans()
            .subscribe(data =>{
                this.loans = data;
                if (this.loans.some(loan => loan.member_id_fk === +this.savingsForm.value.member_id && this.savingsForm.value.loans_bf > 0 && this.savingsForm.value.adv_bf > 0 )){
                    
                }

            })

            //BEGIN LOAN FETCH
            this.loanService.getloanById(id)
                .subscribe(data => {
                    this.loans = data;
                    // console.log("This member's loans are", this.loans)
                    let _last = this.loans[this.loans.length - 1]
                    //get repayment
                    for (let _loans of this.loans) {
                        //begin longterm
                        if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 1) {
                            this.savingsForm.patchValue({
                                loan_id_fk: _loans.loan_id
                            });
                            //console.log("This loan is long term active", _loans.loan_id)
                            this.loanService.getRepaymentsID(_loans.loan_id)
                                .subscribe(data => {
                                    this.loanrepays = data;
                                    //console.log("Repays for this loan ", this.loanrepays)
                                    if (this.loanrepays.some(_loan => {
                                        return _loan.loan_id_fk === _loans.loan_id;
                                    })) {
                                        for (let _loan_repay of this.loanrepays) {
                                            // console.log("This loan repays amount", _loan_repay.principal_amount)
                                            //get total repay
                                            this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                let _principal_amount = a.principal_amount;
                                                return result + _principal_amount;
                                            }, 0);
                                            //console.log("Total repayment", this._total_repay)
                                        }
                                        this._loan_bf = _loans.loan_amount - this._total_repay;
                                        //console.log("Total loan bf is", this._loan_bf)
                                        //Get interest repayment
                                        this.loanService.getRates()
                                            .subscribe(data => {
                                                this.lrates = data;
                                                //console.log("this rates", this.lrates)
                                                for (let _lrates of this.lrates) {
                                                    this._loan_interest = Math.round(((_lrates.normal_rate * this._loan_bf) / 100)/5)*5
                                                    //console.log("loan interest", this._loan_interest)
                                                    this.savingsForm.patchValue({
                                                        loan_interest: this._loan_interest,
                                                        loans_bf: this._loan_bf
                                                    });
                                                }
                                            })
                                    } else {
                                        this._loan_bf = _loans.loan_amount;
                                        this.loanService.getRates()
                                            .subscribe(data => {
                                                this.lrates = data;
                                                //console.log("this rates", this.lrates)
                                                for (let _lrates of this.lrates) {
                                                    this._loan_interest = Math.round(((_lrates.normal_rate * this._loan_bf) / 100)/5)*5
                                                    //console.log("loan interest", this._loan_interest)
                                                    this.savingsForm.patchValue({
                                                        loan_interest: this._loan_interest,
                                                        loans_bf: this._loan_bf
                                                    });
                                                }
                                            })
                                        // console.log("This new loan", this._loan_bf)                  
                                    }
                                })
                        } else {
                            this._loan_bf = 0
                            this._loan_interest = 0
                            this.savingsForm.patchValue({
                                loan_interest: this._loan_interest,
                                loans_bf: this._loan_bf
                            });
                        }
                        //Pending loans
                        if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                            this._pendingMsg = "" + _loans.loan_amount
                        }

                        //End Long Term

                        //begin advance
                        if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 2) {
                            //console.log("This loan is advance active", _loans.loan_id)
                            this.savingsForm.patchValue({
                                adv_id_fk: _loans.loan_id
                            });
                            this.loanService.getRepaymentsID(_loans.loan_id)
                                .subscribe(data => {
                                    this.loanrepays = data;
                                    //console.log("Repays for this advance loan ", this.loanrepays)
                                    if (this.loanrepays.some(_loan => {
                                        return _loan.loan_id_fk === _loans.loan_id;
                                    })) {
                                        for (let _loan_repay of this.loanrepays) {
                                            // console.log("This advance loan repays amount", _loan_repay.principal_amount)
                                            //get total repay
                                            this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                let _principal_amount = a.principal_amount;
                                                return result + _principal_amount;
                                            }, 0);
                                            //console.log("Total advance repayment", this._total_repay)
                                        }
                                        this._adv_bf = _loans.loan_amount - this._total_repay;
                                        // console.log("Total adv bf is", this._adv_bf)
                                        //Get interest repayment
                                        this.loanService.getRates()
                                            .subscribe(data => {
                                                this.lrates = data;
                                                //console.log("this rates", this.lrates)
                                                for (let _lrates of this.lrates) {
                                                    this._adv_loan_interest = Math.round(((_lrates.advance_rate * this._adv_bf) / 100)/5)*5
                                                    //console.log("loan interest", this._loan_interest)
                                                    this.savingsForm.patchValue({
                                                        adv_loan_interest: this._adv_loan_interest,
                                                        adv_bf: this._adv_bf
                                                    });
                                                }
                                            })
                                    } else {
                                        this._adv_bf = _loans.loan_amount;
                                        this.loanService.getRates()
                                            .subscribe(data => {
                                                this.lrates = data;
                                                //console.log("this rates", this.lrates)
                                                for (let _lrates of this.lrates) {
                                                    this._adv_loan_interest = Math.round(((_lrates.advance_rate * this._adv_bf) / 100)/5)*5
                                                    //console.log("loan interest", this._loan_interest)
                                                    this.savingsForm.patchValue({
                                                        adv_loan_interest: this._adv_loan_interest,
                                                        adv_bf: this._adv_bf
                                                    });
                                                }
                                            })
                                    }
                                })
                        } else {
                            this._adv_bf = 0
                            this._adv_loan_interest = 0
                            this.savingsForm.patchValue({
                                adv_loan_interest: this._adv_loan_interest,
                                adv_bf: this._adv_bf
                            });
                        }    
                //End advance
                    }
                })
            //END LOAN FETCH                 
        });
    }
    //End ngOnit


    //get control
    get f() {
        return this.savingsForm.controls;
      }

      newMemberSavings(){
        const newSavings = {
            member_id_fk: this.savingsForm.value.member_id,
            savings_amount: this.savingsForm.value.savings_amount,
            savings_bf: this.savingsForm.value.savings_bf,
            total_payments: this.savingsForm.value.total_payments,
            savings_date: this.savingsForm.value.savings_date,
            comments: this.savingsForm.value.comments
        }
        this.savingsService.addSavings(newSavings)
            .subscribe(data => {
                console.log(data)
                /// this.savings.push(data);
                this.successMsg = "Savings successfully submitted";
                this.route.paramMap.subscribe((params: ParamMap) => {
                    let id = parseInt(params.get('id'));

                    //savings refresh
                    this.savingsService.getSavingsById(id).subscribe(s => {
                        this.savings = s;
                        console.log(this.savings);
                        //get total savings
                        this._savings_total = +this.savings.reduce((result, a) => {
                            var savings_amount = a.savings_amount;
                            return result + savings_amount;
                        }, 0);
                        //get savings bf
                        this._savings_bf = +this.savings.reduce((result, a) => {
                            let savings_bf = a.savings_bf;
                            return result + savings_bf;
                        }, 0);
                        //Get total savings bf
                        this._total_savings = this._savings_total + this._savings_bf
                    });
                    //end savings refresh

                    //this.savingsForm.reset();
                    this.errorMsg = null;
                    for (let i in this.savingsForm.controls) {
                        this.savingsForm.controls[i].setErrors(null);
                    }

                },
                    //display a failure error
                    error => this.errorMsg = error);
            })
        //end savings

        //submit loans
        if (this.savingsForm.value.loans_bf > 0) {
            const loanRepay = {
                loan_id_fk: this.savingsForm.value.loan_id_fk,
                principal_amount: this.savingsForm.value.principal_amount,
                interest: this.savingsForm.value.loan_interest,
                default_amount: this.savingsForm.value.fines,
                date_of_payment: this.savingsForm.value.savings_date
            }
            this.loanService.addRepayment(loanRepay)
                .subscribe(data => {
                    console.log("This submitted repay", data)
                    //BEGIN LOAN FETCH
                    this.loanService.getloanById(this.savingsForm.value.member_id)
                        .subscribe(data => {
                            this.loans = data;
                            // console.log("This member's loans are", this.loans)
                            let _last = this.loans[this.loans.length - 1]
                            //get repayment
                            for (let _loans of this.loans) {
                                //begin longterm
                                if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 1) {
                                    this.savingsForm.patchValue({
                                        loan_id_fk: _loans.loan_id
                                    });
                                    //console.log("This loan is long term active", _loans.loan_id)
                                    this.loanService.getRepaymentsID(_loans.loan_id)
                                        .subscribe(data => {
                                            this.loanrepays = data;
                                            //console.log("Repays for this loan ", this.loanrepays)
                                            if (this.loanrepays.some(_loan => {
                                                return _loan.loan_id_fk === _loans.loan_id;
                                            })) {
                                                for (let _loan_repay of this.loanrepays) {
                                                    // console.log("This loan repays amount", _loan_repay.principal_amount)
                                                    //get total repay
                                                    this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                        let _principal_amount = a.principal_amount;
                                                        return result + _principal_amount;
                                                    }, 0);
                                                    //console.log("Total repayment", this._total_repay)
                                                }
                                                this._loan_bf = _loans.loan_amount - this._total_repay;
                                                //console.log("Total loan bf is", this._loan_bf)
                                                //Get interest repayment
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                loan_interest: this._loan_interest,
                                                                loans_bf: this._loan_bf
                                                            });
                                                        }
                                                    })
                                            } else {
                                                this._loan_bf = _loans.loan_amount;
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                loan_interest: this._loan_interest,
                                                                loans_bf: this._loan_bf
                                                            });
                                                        }
                                                    })
                                                // console.log("This new loan", this._loan_bf)                  
                                            }
                                        })
                                } else {
                                    this._loan_bf = 0
                                    this._loan_interest = 0
                                    this.savingsForm.patchValue({
                                        loan_interest: this._loan_interest,
                                        loans_bf: this._loan_bf
                                    });
                                }
                                //Pending loans
                                if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                                    this._pendingMsg = "" + _loans.loan_amount
                                }

                                //End Long Term

                                //begin advance
                                if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 2) {
                                    //console.log("This loan is advance active", _loans.loan_id)
                                    this.savingsForm.patchValue({
                                        adv_id_fk: _loans.loan_id
                                    });
                                    this.loanService.getRepaymentsID(_loans.loan_id)
                                        .subscribe(data => {
                                            this.loanrepays = data;
                                            //console.log("Repays for this advance loan ", this.loanrepays)
                                            if (this.loanrepays.some(_loan => {
                                                return _loan.loan_id_fk === _loans.loan_id;
                                            })) {
                                                for (let _loan_repay of this.loanrepays) {
                                                    // console.log("This advance loan repays amount", _loan_repay.principal_amount)
                                                    //get total repay
                                                    this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                        let _principal_amount = a.principal_amount;
                                                        return result + _principal_amount;
                                                    }, 0);
                                                    //console.log("Total advance repayment", this._total_repay)
                                                }
                                                this._adv_bf = _loans.loan_amount - this._total_repay;
                                                // console.log("Total adv bf is", this._adv_bf)
                                                //Get interest repayment
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._adv_loan_interest = (_lrates.advance_rate * this._adv_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                adv_loan_interest: this._adv_loan_interest,
                                                                adv_bf: this._adv_bf
                                                            });
                                                        }
                                                    })
                                            } else {
                                                this._adv_bf = _loans.loan_amount;
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._adv_loan_interest = (_lrates.advance_rate * this._adv_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                adv_loan_interest: this._adv_loan_interest,
                                                                adv_bf: this._adv_bf
                                                            });
                                                        }
                                                    })
                                            }
                                        })
                                } else {
                                    this._adv_bf = 0
                                    this._adv_loan_interest = 0
                                    this.savingsForm.patchValue({
                                        adv_loan_interest: this._adv_loan_interest,
                                        adv_bf: this._adv_bf
                                    });
                                }


                                //Pending Advance
                                if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 2) {
                                    this._pendingAdvMsg = "" + _loans.loan_amount
                                }

                                if (this._pendingMsg && this._pendingAdvMsg) {
                                    this._pendingLoansMsg = "Application denied:: You already have pending loan applications!"
                                }

                                if ((this._pendingMsg && _loans.loan_amount > 0) || (this._pendingAdvMsg && _loans.loan_amount > 0)) {
                                    this._pendingLoansMsg = "Application denied: You have a pre-existing loan and a pending loan application"
                                }

                                //End advance
                            }
                        })
                    //END LOAN FETCH  
                })
        }
        //const loanRepay
        //end submit loans

        //submit advance
        if (this.savingsForm.value.adv_bf > 0) {
            console.log("This advance is present")
            const advRepay = {
                loan_id_fk: this.savingsForm.value.adv_id_fk,
                principal_amount: this.savingsForm.value.principal_adv,
                interest: this.savingsForm.value.adv_loan_interest,
                default_amount: this.savingsForm.value.fines,
                date_of_payment: this.savingsForm.value.savings_date
            }
            this.loanService.addRepayment(advRepay)
                .subscribe(data => {
                    console.log("This submitted repay", data)
                    //BEGIN LOAN FETCH
                    this.loanService.getloanById(this.savingsForm.value.member_id)
                        .subscribe(data => {
                            this.loans = data;
                            // console.log("This member's loans are", this.loans)
                            let _last = this.loans[this.loans.length - 1]
                            //get repayment
                            for (let _loans of this.loans) {
                                //begin longterm
                                if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 1) {
                                    this.savingsForm.patchValue({
                                        loan_id_fk: _loans.loan_id
                                    });
                                    //console.log("This loan is long term active", _loans.loan_id)
                                    this.loanService.getRepaymentsID(_loans.loan_id)
                                        .subscribe(data => {
                                            this.loanrepays = data;
                                            //console.log("Repays for this loan ", this.loanrepays)
                                            if (this.loanrepays.some(_loan => {
                                                return _loan.loan_id_fk === _loans.loan_id;
                                            })) {
                                                for (let _loan_repay of this.loanrepays) {
                                                    // console.log("This loan repays amount", _loan_repay.principal_amount)
                                                    //get total repay
                                                    this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                        let _principal_amount = a.principal_amount;
                                                        return result + _principal_amount;
                                                    }, 0);
                                                    //console.log("Total repayment", this._total_repay)
                                                }
                                                this._loan_bf = _loans.loan_amount - this._total_repay;
                                                //console.log("Total loan bf is", this._loan_bf)
                                                //Get interest repayment
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                loan_interest: this._loan_interest,
                                                                loans_bf: this._loan_bf
                                                            });
                                                        }
                                                    })
                                            } else {
                                                this._loan_bf = _loans.loan_amount;
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                loan_interest: this._loan_interest,
                                                                loans_bf: this._loan_bf
                                                            });
                                                        }
                                                    })
                                                // console.log("This new loan", this._loan_bf)                  
                                            }
                                        })
                                } else {
                                    this._loan_bf = 0
                                    this._loan_interest = 0
                                    this.savingsForm.patchValue({
                                        loan_interest: this._loan_interest,
                                        loans_bf: this._loan_bf
                                    });
                                }
                                //Pending loans
                                if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                                    this._pendingMsg = "" + _loans.loan_amount
                                }

                                //End Long Term

                                //begin advance
                                if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 2) {
                                    //console.log("This loan is advance active", _loans.loan_id)
                                    this.savingsForm.patchValue({
                                        adv_id_fk: _loans.loan_id
                                    });
                                    this.loanService.getRepaymentsID(_loans.loan_id)
                                        .subscribe(data => {
                                            this.loanrepays = data;
                                            //console.log("Repays for this advance loan ", this.loanrepays)
                                            if (this.loanrepays.some(_loan => {
                                                return _loan.loan_id_fk === _loans.loan_id;
                                            })) {
                                                for (let _loan_repay of this.loanrepays) {
                                                    // console.log("This advance loan repays amount", _loan_repay.principal_amount)
                                                    //get total repay
                                                    this._total_repay = +this.loanrepays.reduce((result, a) => {
                                                        let _principal_amount = a.principal_amount;
                                                        return result + _principal_amount;
                                                    }, 0);
                                                    //console.log("Total advance repayment", this._total_repay)
                                                }
                                                this._adv_bf = _loans.loan_amount - this._total_repay;
                                                // console.log("Total adv bf is", this._adv_bf)
                                                //Get interest repayment
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._adv_loan_interest = (_lrates.advance_rate * this._adv_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                adv_loan_interest: this._adv_loan_interest,
                                                                adv_bf: this._adv_bf
                                                            });
                                                        }
                                                    })
                                            } else {
                                                this._adv_bf = _loans.loan_amount;
                                                this.loanService.getRates()
                                                    .subscribe(data => {
                                                        this.lrates = data;
                                                        //console.log("this rates", this.lrates)
                                                        for (let _lrates of this.lrates) {
                                                            this._adv_loan_interest = (_lrates.advance_rate * this._adv_bf) / 100
                                                            //console.log("loan interest", this._loan_interest)
                                                            this.savingsForm.patchValue({
                                                                adv_loan_interest: this._adv_loan_interest,
                                                                adv_bf: this._adv_bf
                                                            });
                                                        }
                                                    })
                                            }
                                        })
                                } else {
                                    this._adv_bf = 0
                                    this._adv_loan_interest = 0
                                    this.savingsForm.patchValue({
                                        adv_loan_interest: this._adv_loan_interest,
                                        adv_bf: this._adv_bf
                                    });
                                }


                                //Pending Advance
                                if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 2) {
                                    this._pendingAdvMsg = "" + _loans.loan_amount
                                }

                                if (this._pendingMsg && this._pendingAdvMsg) {
                                    this._pendingLoansMsg = "Application denied:: You already have pending loan applications!"
                                }

                                if ((this._pendingMsg && _loans.loan_amount > 0) || (this._pendingAdvMsg && _loans.loan_amount > 0)) {
                                    this._pendingLoansMsg = "Application denied: You have a pre-existing loan and a pending loan application"
                                }

                                //End advance
                            }
                        })
                    //END LOAN FETCH  
                })
        }
        //end submit advance

      }
      

    //submit savings
    addMemberSavings() {
        //alert("This values"+this.savingsForm.value)
        console.log("This values", this.savingsForm.value)
        //savings
        this.newMemberSavings()
        //clear form
        this.reset();
        for (let i in this.savingsForm.controls) {
            this.savingsForm.controls[i].setErrors(null);
          }
    }

   

    reset(){
          
        for (let i in this.savingsForm.controls) {
            this.savingsForm.controls[i].setErrors(null);
          }

     this.savingsForm.patchValue({
         savings_date: null,
         total_payments: null,
         savings_amount: null,
         savings_bf:null,
         principal_amount: null,
         principal_adv: null,
         fines:null,
         comments:null
     })     
    }


    myChangeFunction(){
        console.log("This is it")
    }

    savingsChange(){
        if(this.savingsForm.value.savings_amount == 0){
            this.savingsForm.patchValue({
                fines: 50
            })
        }
    }
}
