import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';

@Component({
  selector: 'app-reports',
  templateUrl: './reports.component.html',
  styleUrls: ['./reports.component.css']
})
export class ReportsComponent implements OnInit {

  constructor(private route: ActivatedRoute, private router: Router) { }

  public barChartOptions = {
    scaleShowVerticalLines: false,
    responsive: true
  };
  public barChartLabels = ['2006', '2007', '2008', '2009', '2010', '2011', '2012'];
  public barChartType = 'bar';
  public barChartLegend = true;
  public barChartData = [
    { data: [65, 59, 80, 81, 56, 55, 40], label: 'Series A' },
    { data: [28, 48, 40, 19, 86, 27, 90], label: 'Series B' },
    { data: [38, 88, 47, 19, 46, 57, 60], label: 'Series C' }
  ];
  ngOnInit() {
  }

  goBranch(){
    this.router.navigate(['./branch-report'], { relativeTo: this.route })
  }

  goGroup(){
    this.router.navigate(['./group-report'], { relativeTo: this.route })
  }

  goMember(){
    this.router.navigate(['./member-report'], { relativeTo: this.route })
  }

}
