import { defineConfig, devices } from '@playwright/test';

/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// import dotenv from 'dotenv';
// import path from 'path';
// dotenv.config({ path: path.resolve(__dirname, '.env') });

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  testDir: './e2e',
  timeout: 25_000,
  fullyParallel: true, // Run tests in files in parallel
  forbidOnly: !!process.env.CI, // Fail the build on CI if you accidentally left test.only in the source code.
  retries: process.env.CI ? 2 : 0, // Retry on CI only
  //workers: process.env.CI ? 1 : undefined, // Opt out of parallel tests on CI.
  reporter: 'html', // Reporter to use. See https://playwright.dev/docs/test-reporters
  use: { // Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions.
    /* Base URL to use in actions like `await page.goto('/')`. */
    // baseURL: 'http://127.0.0.1:3000',

    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: 'on-first-retry',
    timezoneId: 'Europe/Rome',
    launchOptions: {
      args: [
        '--disable-font-subpixel-positioning',
      ]
    },
  },

  /* Configure projects for major browsers */
  projects: [
    {
      name: 'chromium',
      use: {
          ...devices['Desktop Chrome'],
          viewport: { width: 1920, height: 1080 },
      },
    },
    {
      name: 'Android',
      use: { ...devices['Pixel 7'] },
    },
    {
      name: 'iPhone 6',
      use: { ...devices['iPhone 6'] },
    },
    {
      name: 'firefox',
      use: { ...devices['Desktop Firefox'] },
    }
/*
    {
      name: 'firefox',
      use: { ...devices['Desktop Firefox'] },
    },

    {
      name: 'webkit',
      use: { ...devices['Desktop Safari'] },
    },*/

    /* Test against mobile viewports. */
    // {
    //   name: 'Mobile Chrome',
    //   use: { ...devices['Pixel 5'] },
    // },
    // {
    //   name: 'Mobile Safari',
    //   use: { ...devices['iPhone 12'] },
    // },

    /* Test against branded browsers. */
    // {
    //   name: 'Microsoft Edge',
    //   use: { ...devices['Desktop Edge'], channel: 'msedge' },
    // },
    // {
    //   name: 'Google Chrome',
    //   use: { ...devices['Desktop Chrome'], channel: 'chrome' },
    // },
  ],

  expect: {
    toHaveScreenshot: {
      stylePath: 'e2e/screenshot.css',
      threshold: 0.5,
    },
  },
  /* Run your local dev server before starting the tests */
   webServer: [{
     command: 'npm run server-for-test',
     url: 'http://127.0.0.1:81',
     reuseExistingServer: !process.env.CI,
   }, {
       command: 'rm -rf tests/work2 && node dist/src --cwd tests/work2 --debug --port 82 --open_browser_at_start false',
       url: 'http://127.0.0.1:82',
       reuseExistingServer: !process.env.CI,
   }]
});
