/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fineract.client.models.GetLoanRescheduleRequestStatus;
import org.apache.fineract.client.models.LoanTermVariationsData;
import org.apache.fineract.client.models.RescheduleReasonsCodeValue;
import org.apache.fineract.client.models.RescheduleReasonsTimeline;

/**
 * GetLoanRescheduleRequestResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoanRescheduleRequestResponse {
  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_CLIENT_NAME = "clientName";
  @SerializedName(SERIALIZED_NAME_CLIENT_NAME)
  private String clientName;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_LOAN_ACCOUNT_NUMBER = "loanAccountNumber";
  @SerializedName(SERIALIZED_NAME_LOAN_ACCOUNT_NUMBER)
  private String loanAccountNumber;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_LOAN_TERM_VARIATIONS_DATA = "loanTermVariationsData";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_VARIATIONS_DATA)
  private Set<LoanTermVariationsData> loanTermVariationsData;

  public static final String SERIALIZED_NAME_RECALCULATE_INTEREST = "recalculateInterest";
  @SerializedName(SERIALIZED_NAME_RECALCULATE_INTEREST)
  private Boolean recalculateInterest;

  public static final String SERIALIZED_NAME_RESCHEDULE_FROM_DATE = "rescheduleFromDate";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_FROM_DATE)
  private LocalDate rescheduleFromDate;

  public static final String SERIALIZED_NAME_RESCHEDULE_FROM_INSTALLMENT = "rescheduleFromInstallment";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_FROM_INSTALLMENT)
  private Integer rescheduleFromInstallment;

  public static final String SERIALIZED_NAME_RESCHEDULE_REASON_CODE_VALUE = "rescheduleReasonCodeValue";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_REASON_CODE_VALUE)
  private RescheduleReasonsCodeValue rescheduleReasonCodeValue;

  public static final String SERIALIZED_NAME_RESCHEDULE_REASON_COMMENT = "rescheduleReasonComment";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_REASON_COMMENT)
  private String rescheduleReasonComment;

  public static final String SERIALIZED_NAME_STATUS_ENUM = "statusEnum";
  @SerializedName(SERIALIZED_NAME_STATUS_ENUM)
  private GetLoanRescheduleRequestStatus statusEnum;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private RescheduleReasonsTimeline timeline;

  public GetLoanRescheduleRequestResponse() {
  }

  public GetLoanRescheduleRequestResponse clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public GetLoanRescheduleRequestResponse clientName(String clientName) {
    
    this.clientName = clientName;
    return this;
  }

  /**
   * Get clientName
   * @return clientName
   */
  @javax.annotation.Nullable

  public String getClientName() {
    return clientName;
  }


  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  public GetLoanRescheduleRequestResponse id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GetLoanRescheduleRequestResponse loanAccountNumber(String loanAccountNumber) {
    
    this.loanAccountNumber = loanAccountNumber;
    return this;
  }

  /**
   * Get loanAccountNumber
   * @return loanAccountNumber
   */
  @javax.annotation.Nullable

  public String getLoanAccountNumber() {
    return loanAccountNumber;
  }


  public void setLoanAccountNumber(String loanAccountNumber) {
    this.loanAccountNumber = loanAccountNumber;
  }

  public GetLoanRescheduleRequestResponse loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public GetLoanRescheduleRequestResponse loanTermVariationsData(Set<LoanTermVariationsData> loanTermVariationsData) {
    
    this.loanTermVariationsData = loanTermVariationsData;
    return this;
  }

  public GetLoanRescheduleRequestResponse addLoanTermVariationsDataItem(LoanTermVariationsData loanTermVariationsDataItem) {
    if (this.loanTermVariationsData == null) {
      this.loanTermVariationsData = new LinkedHashSet<>();
    }
    this.loanTermVariationsData.add(loanTermVariationsDataItem);
    return this;
  }

  /**
   * Get loanTermVariationsData
   * @return loanTermVariationsData
   */
  @javax.annotation.Nullable

  public Set<LoanTermVariationsData> getLoanTermVariationsData() {
    return loanTermVariationsData;
  }


  public void setLoanTermVariationsData(Set<LoanTermVariationsData> loanTermVariationsData) {
    this.loanTermVariationsData = loanTermVariationsData;
  }

  public GetLoanRescheduleRequestResponse recalculateInterest(Boolean recalculateInterest) {
    
    this.recalculateInterest = recalculateInterest;
    return this;
  }

  /**
   * Get recalculateInterest
   * @return recalculateInterest
   */
  @javax.annotation.Nullable

  public Boolean getRecalculateInterest() {
    return recalculateInterest;
  }


  public void setRecalculateInterest(Boolean recalculateInterest) {
    this.recalculateInterest = recalculateInterest;
  }

  public GetLoanRescheduleRequestResponse rescheduleFromDate(LocalDate rescheduleFromDate) {
    
    this.rescheduleFromDate = rescheduleFromDate;
    return this;
  }

  /**
   * Get rescheduleFromDate
   * @return rescheduleFromDate
   */
  @javax.annotation.Nullable

  public LocalDate getRescheduleFromDate() {
    return rescheduleFromDate;
  }


  public void setRescheduleFromDate(LocalDate rescheduleFromDate) {
    this.rescheduleFromDate = rescheduleFromDate;
  }

  public GetLoanRescheduleRequestResponse rescheduleFromInstallment(Integer rescheduleFromInstallment) {
    
    this.rescheduleFromInstallment = rescheduleFromInstallment;
    return this;
  }

  /**
   * Get rescheduleFromInstallment
   * @return rescheduleFromInstallment
   */
  @javax.annotation.Nullable

  public Integer getRescheduleFromInstallment() {
    return rescheduleFromInstallment;
  }


  public void setRescheduleFromInstallment(Integer rescheduleFromInstallment) {
    this.rescheduleFromInstallment = rescheduleFromInstallment;
  }

  public GetLoanRescheduleRequestResponse rescheduleReasonCodeValue(RescheduleReasonsCodeValue rescheduleReasonCodeValue) {
    
    this.rescheduleReasonCodeValue = rescheduleReasonCodeValue;
    return this;
  }

  /**
   * Get rescheduleReasonCodeValue
   * @return rescheduleReasonCodeValue
   */
  @javax.annotation.Nullable

  public RescheduleReasonsCodeValue getRescheduleReasonCodeValue() {
    return rescheduleReasonCodeValue;
  }


  public void setRescheduleReasonCodeValue(RescheduleReasonsCodeValue rescheduleReasonCodeValue) {
    this.rescheduleReasonCodeValue = rescheduleReasonCodeValue;
  }

  public GetLoanRescheduleRequestResponse rescheduleReasonComment(String rescheduleReasonComment) {
    
    this.rescheduleReasonComment = rescheduleReasonComment;
    return this;
  }

  /**
   * Get rescheduleReasonComment
   * @return rescheduleReasonComment
   */
  @javax.annotation.Nullable

  public String getRescheduleReasonComment() {
    return rescheduleReasonComment;
  }


  public void setRescheduleReasonComment(String rescheduleReasonComment) {
    this.rescheduleReasonComment = rescheduleReasonComment;
  }

  public GetLoanRescheduleRequestResponse statusEnum(GetLoanRescheduleRequestStatus statusEnum) {
    
    this.statusEnum = statusEnum;
    return this;
  }

  /**
   * Get statusEnum
   * @return statusEnum
   */
  @javax.annotation.Nullable

  public GetLoanRescheduleRequestStatus getStatusEnum() {
    return statusEnum;
  }


  public void setStatusEnum(GetLoanRescheduleRequestStatus statusEnum) {
    this.statusEnum = statusEnum;
  }

  public GetLoanRescheduleRequestResponse timeline(RescheduleReasonsTimeline timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public RescheduleReasonsTimeline getTimeline() {
    return timeline;
  }


  public void setTimeline(RescheduleReasonsTimeline timeline) {
    this.timeline = timeline;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoanRescheduleRequestResponse getLoanRescheduleRequestResponse = (GetLoanRescheduleRequestResponse) o;
    return Objects.equals(this.clientId, getLoanRescheduleRequestResponse.clientId) &&
        Objects.equals(this.clientName, getLoanRescheduleRequestResponse.clientName) &&
        Objects.equals(this.id, getLoanRescheduleRequestResponse.id) &&
        Objects.equals(this.loanAccountNumber, getLoanRescheduleRequestResponse.loanAccountNumber) &&
        Objects.equals(this.loanId, getLoanRescheduleRequestResponse.loanId) &&
        Objects.equals(this.loanTermVariationsData, getLoanRescheduleRequestResponse.loanTermVariationsData) &&
        Objects.equals(this.recalculateInterest, getLoanRescheduleRequestResponse.recalculateInterest) &&
        Objects.equals(this.rescheduleFromDate, getLoanRescheduleRequestResponse.rescheduleFromDate) &&
        Objects.equals(this.rescheduleFromInstallment, getLoanRescheduleRequestResponse.rescheduleFromInstallment) &&
        Objects.equals(this.rescheduleReasonCodeValue, getLoanRescheduleRequestResponse.rescheduleReasonCodeValue) &&
        Objects.equals(this.rescheduleReasonComment, getLoanRescheduleRequestResponse.rescheduleReasonComment) &&
        Objects.equals(this.statusEnum, getLoanRescheduleRequestResponse.statusEnum) &&
        Objects.equals(this.timeline, getLoanRescheduleRequestResponse.timeline);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, clientName, id, loanAccountNumber, loanId, loanTermVariationsData, recalculateInterest, rescheduleFromDate, rescheduleFromInstallment, rescheduleReasonCodeValue, rescheduleReasonComment, statusEnum, timeline);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoanRescheduleRequestResponse {\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loanAccountNumber: ").append(toIndentedString(loanAccountNumber)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    loanTermVariationsData: ").append(toIndentedString(loanTermVariationsData)).append("\n");
    sb.append("    recalculateInterest: ").append(toIndentedString(recalculateInterest)).append("\n");
    sb.append("    rescheduleFromDate: ").append(toIndentedString(rescheduleFromDate)).append("\n");
    sb.append("    rescheduleFromInstallment: ").append(toIndentedString(rescheduleFromInstallment)).append("\n");
    sb.append("    rescheduleReasonCodeValue: ").append(toIndentedString(rescheduleReasonCodeValue)).append("\n");
    sb.append("    rescheduleReasonComment: ").append(toIndentedString(rescheduleReasonComment)).append("\n");
    sb.append("    statusEnum: ").append(toIndentedString(statusEnum)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

