package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.LoanPointInTimeData;
import org.apache.fineract.client.models.RetrieveLoansPointInTimeExternalIdsRequest;
import org.apache.fineract.client.models.RetrieveLoansPointInTimeRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoansPointInTimeApi {
    /**
    * 
    * 
        * @param loanId loanId (required)
        * @param date date (required)
        * @param dateFormat dateFormat (optional)
        * @param locale locale (optional)
    * @return Call&lt;LoanPointInTimeData&gt;
    */
    @GET("v1/loans/at-date/{loanId}")
    Call<LoanPointInTimeData> retrieveLoanPointInTime(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("date") Object date, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale);

    /**
    * 
    * 
        * @param loanExternalId loanExternalId (required)
        * @param date date (required)
        * @param dateFormat dateFormat (optional)
        * @param locale locale (optional)
    * @return Call&lt;LoanPointInTimeData&gt;
    */
    @GET("v1/loans/at-date/external-id/{loanExternalId}")
    Call<LoanPointInTimeData> retrieveLoanPointInTimeByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("date") Object date, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale);

    /**
    * 
    * 
        * @param retrieveLoansPointInTimeRequest  (optional)
    * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/at-date/search")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTime(@retrofit2.http.Body RetrieveLoansPointInTimeRequest retrieveLoansPointInTimeRequest);

    /**
    * 
    * 
        * @param retrieveLoansPointInTimeExternalIdsRequest  (optional)
    * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/at-date/search/external-id")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTimeByExternalIds(@retrofit2.http.Body RetrieveLoansPointInTimeExternalIdsRequest retrieveLoansPointInTimeExternalIdsRequest);


        /**
        * 
        * 
            * @param retrieveLoansPointInTimeRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTime();
        /**
        * 
        * 
            * @param retrieveLoansPointInTimeExternalIdsRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search/external-id")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTimeByExternalIds();

        /**
        * 
        * 
            * @param loanId loanId (required)
            * @param date date (required)
            * @param dateFormat dateFormat (optional)
            * @param locale locale (optional)
        * @return Call&lt;LoanPointInTimeData&gt;
        */
    @GET("v1/loans/at-date/{loanId}")
    Call<LoanPointInTimeData> retrieveLoanPointInTime(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("date") Object date, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanExternalId loanExternalId (required)
            * @param date date (required)
            * @param dateFormat dateFormat (optional)
            * @param locale locale (optional)
        * @return Call&lt;LoanPointInTimeData&gt;
        */
    @GET("v1/loans/at-date/external-id/{loanExternalId}")
    Call<LoanPointInTimeData> retrieveLoanPointInTimeByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("date") Object date, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param retrieveLoansPointInTimeRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTime(@retrofit2.http.Body RetrieveLoansPointInTimeRequest retrieveLoansPointInTimeRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param retrieveLoansPointInTimeExternalIdsRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search/external-id")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTimeByExternalIds(@retrofit2.http.Body RetrieveLoansPointInTimeExternalIdsRequest retrieveLoansPointInTimeExternalIdsRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param retrieveLoansPointInTimeRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTime(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param retrieveLoansPointInTimeExternalIdsRequest  (optional)
        * @return Call&lt;List&lt;LoanPointInTimeData&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/at-date/search/external-id")
    Call<List<LoanPointInTimeData>> retrieveLoansPointInTimeByExternalIds(@HeaderMap Map<String, String> headers);
}
